function score(effectProp, maxRange, renderItemTemplate)
{
    // Start supressing dialogs and clearing cache
    app.beginSuppressDialogs();
    app.purge(PurgeTarget.ALL_CACHES);

    // The amount of time to keep the loop running
    var seconds = 60;

    // Declaring our variables
    var score       = 0,                                        // The score, overwritten each time
        endTime     = new Date().getTime() + seconds * 1000,    // Number of milliseconds in the future
        queue       = app.project.renderQueue,                  // Getting the renderqueue object
        output      = File("~/aebenchmark_[####].exr"),
        lastTime    = new Date().getTime();


    // While the current time is smaller than the end time
    while(new Date().getTime() < endTime) {
        // Note that for some reason if this isn't changed each render then AE caches even when you purge cache
        effectProp.setValue(Math.ceil(Math.random() * maxRange));            // Setting the given proeprty value randomly
        
        // Duplicate our renderItem, set it's property, render and remove
        var renderItem = renderItemTemplate.duplicate();
        renderItem.outputModule(1).file = output;
        queue.render();
        renderItem.remove();

        var now = new Date().getTime();         // Get the current time 

        // Here we check if we're still within the set second time limit
        if(now < endTime) {                     // If we have not reached the time limit yet
            score += 1;                         // Then add 1 to the score
            lastTime = new Date().getTime();    // And set the last succesful render time
        }
        else {                                  // If however we have gone past the time limit
            var length = now - lastTime;        // Work out how long this frame took to render
            var window = endTime - lastTime;    // How much time happened before the end time
            var percentage = window / length;   // What percentage of the render took place inside the window
            percentage = Math.round(percentage * 100) / 100;    // Rounding to two decimal points

            // We calculated how much of the render time above is valid (within the time frame)
            score += percentage;                // Then we add it to the score for more accuracy
        }
    }

    // End the supression of dialogs to allow alerts to appear again, and return the score
    app.endSuppressDialogs(false);
    return score;
}